'use strict';

var video;
// Please comment the role of this variable
var fps = 12;

// Please comment and better explain this data structure in your lab report
var rois;

// Please explain the role of these variables
var dragging; // What is this boolean about
var roiDragged; // What is this index about

// This variable represents a shift between the roi center and the user's click 
var roiOffset = {x:0,y:0};

// When is this function called?

function doLoad() {

    // Comment if needed
    video = document.getElementById("video"); //!!

    // Please comment carefully
  
    video.addEventListener('mousedown',startDragging,false); //  how is the mouse here ?
    video.addEventListener('mousemove',dragTime,false);      //  and here 
    video.addEventListener('mouseup',stopDragging,false);    // 
    video.addEventListener('mouseout',stopDragging,false); 
 

    // Initialization
    
    dragging = false;
    roiOffset.x = -1;
    roiOffset.y = -1;


    // Hey! New feature here. Please comment carefully. Refer to the web if needed.
    
    var xhr=new XMLHttpRequest();
    xhr.open("GET","ROIs.json",true);

    xhr.onreadystatechange  = function() {
        if(xhr.readyState  == 4) {
            rois = JSON.parse(xhr.responseText);
        }
    };
    xhr.send(null);

}

// What is this function doing?

function startDragging(event) {

    // Comment
    var mousePosition = {x: event.offsetX, y: event.offsetY}; 

    // Useful computation! Useful for what?
    var frame = Math.min(Math.round(video.currentTime*fps), rois[0].length-1); 

    // Hum,searching something here... what is it?
    
    roiDragged = rois[rois.findIndex((roi) => isInsideROI(mousePosition, roi[frame]))]; 

    // Looks like we found something if this condition is true
    
    if (roiDragged !== undefined) {

        roiOffset.x = mousePosition.x - roiDragged[frame].x;
        roiOffset.y = mousePosition.y - roiDragged[frame].y;
        
        // Why should we actually pause the video playout ?
        video.pause();
        dragging = true;
    }
    

}


// dragTime is a key function bridging the gap between mouse displacement (in image space) and time control of the video
// Please explain it carefully. Maybe a few figures (in your lab report) will support your explanations.

function dragTime(event) {

    if (dragging) {

        // These coordinates represent an ideal position of a ROI what would exactly follow mouse's movement in image space
        var auxX = event.offsetX - roiOffset.x;
        var auxY = event.offsetY - roiOffset.y;

        var dist2Min = Infinity;
        var ind_min = -1;

      
        // Looking for the closest actual ROI position that fits better with user's input 
        for (var frame = 0; frame < roiDragged.length ; frame++) {
            var dx = auxX - roiDragged[frame].x;
            var dy = auxY - roiDragged[frame].y;
            var dist2 = dx * dx + dy * dy;
            if (dist2 < dist2Min) {
                ind_min = frame;
                dist2Min = dist2;
            }
        }


        // You should be ready to get that! Please comment
        video.currentTime = ind_min/fps; 

    }
}

// Quite easy to comment: please do it by yourself

function stopDragging(event) {

    if (dragging) {
        dragging = false;
        // While playing here ?
        video.play();
    }
    

}

// Obvious name, obvious comment from your side

function isInsideROI(pos, roi) {

    return (pos.x>= roi.x-roi.w/2) && (pos.x<= roi.x+roi.w/2) && (pos.y>= roi.y-roi.h/2) && (pos.y<= roi.y+roi.h/2); //!!

}

